<?php
/**
 * discovertheworld functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package discovertheworld
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

if ( ! function_exists( 'discovertheworld_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function discovertheworld_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on discovertheworld, use a find and replace
		 * to change 'discovertheworld' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'discovertheworld', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-main' => esc_html__( 'Primary', 'discovertheworld' ),
				'menu-lang' => esc_html__( 'Lang', 'discovertheworld' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'discovertheworld_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'discovertheworld_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function discovertheworld_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'discovertheworld_content_width', 640 );
}
add_action( 'after_setup_theme', 'discovertheworld_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function discovertheworld_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Bottom Bar', 'discovertheworld' ),
			'id'            => 'dwc-bottom-bar',
			'description'   => esc_html__( 'Add widgets here.', 'discovertheworld' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'discovertheworld_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function discovertheworld_scripts() {

	wp_enqueue_style( 'Font_Awesome', 'https://use.fontawesome.com/releases/v5.6.1/css/all.css' );
	wp_enqueue_style( 'mdb-style', get_template_directory_uri() . '/css/bootstrap.min.css ');
    //wp_enqueue_style( 'mdb-dark-rtl', get_template_directory_uri() . '/css/bootstrap.dark.min.css');

	wp_enqueue_style( 'discovertheworld-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'discovertheworld-style', 'rtl', 'replace' );
	wp_enqueue_style( 'discovertheworld-layout', get_template_directory_uri() . '/css/layout.css');
	
    //wp_enqueue_style( 'discovertheworld-menu', get_template_directory_uri() . '/css/menu.css');
	
	wp_enqueue_script( 'discovertheworld-jquery', get_template_directory_uri() . '/js/jquery-3.4.1.min.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'discovertheworld-bs-js', get_template_directory_uri() . '/js/bootstrap.min.js', array(), _S_VERSION, true );
	//wp_enqueue_script( 'discovertheworld-slider', get_template_directory_uri() . '/js/dwc-slider.js', array(), _S_VERSION, true );
	

	//wp_enqueue_script( 'discovertheworld-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	//wp_enqueue_script( 'discovertheworld-navigation', get_template_directory_uri() . '/js/main.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

    //<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js"></script>
	wp_enqueue_script( 'discovertheworld-google-ads', "https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js", array(), _S_VERSION, true );

}
add_action( 'wp_enqueue_scripts', 'discovertheworld_scripts' );
add_filter('script_loader_tag','dsw_script_loader_tag', 10, 2);
function dsw_script_loader_tag($tag, $handle) {
	if ('discovertheworld-slider' === $handle) {
	    	$src = get_template_directory_uri() . '/js/dwc-slider.js';
	    	$tag = '<script type="module" src="' . esc_url( $src ) . '"></script>';
	} else if ('discovertheworld-google-ads' === $handle){
		$tag =  str_replace( ' src', ' async="async" src', $tag );	
	}
	return $tag;
}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}
function register_navwalker(){
	require_once get_template_directory() . '/class-wp-bootstrap-navwalker.php';
}
add_action( 'after_setup_theme', 'register_navwalker' );
add_filter('nav_menu_css_class' , 'special_nav_class' , 10 , 2);

function special_nav_class ($classes, $item) {
  if (in_array('current-menu-item', $classes) ){
    $classes[] .= ' active ';
  }
  return $classes;
}

function discovertheworld_the_custom_logo() {
    
    $url = get_site_url();
	if (pll_current_language()==='ru') $url .= "/ru";
	echo '<a class="custom-logo-link" href="' . $url . '" >';
	if ( has_custom_logo() ) {

        $logo = wp_get_attachment_image_src( get_theme_mod( 'custom_logo' ) , 'full' );

        echo '<img class="custom-logo" src="' . esc_url( $logo[0] ) . '" width="' . $logo[1] . '" height="' . $logo[2] . '" alt="' . get_bloginfo( 'name' ) . '">';

    } 
	if (display_header_text()) {
	  echo '<span class="text-light dwc-text-shadow">' . get_bloginfo( 'name' ) . '</span>';
	}
    echo "</a>";
}
function dwc_list_categories_post($id){
	$args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    //'category_name' => $name,
    'posts_per_page' => 5,
		'language'=>'ru',
		'cat' => $id,
	//"suppress_filters" => false,
	//	'lang'=>'ru'
);
//global $sitepress;
//$lang='ru';
//$sitepress->switch_lang($lang);
	
$arr_posts = new WP_Query( $args );
//echo 'list:' . $name . '=>' . $arr_posts->have_posts();
	
if ( $arr_posts->have_posts() ) :
    echo '<div>';
    while ( $arr_posts->have_posts() ) :
        $arr_posts->the_post();
        ?>
         <a href=<?php the_permalink(); ?>><h6><?php the_title(); ?></h6></a>
        <?php
    endwhile;
	echo '</div>';
endif;
}
function dwc_list_categories_post_full($name){
	$args = array(
    'post_type' => 'post',
    'post_status' => 'publish',
    'category_name' => $name,
    'posts_per_page' => 5,
);
$arr_posts = new WP_Query( $args );
 
if ( $arr_posts->have_posts() ) :
 
    while ( $arr_posts->have_posts() ) :
        $arr_posts->the_post();
        ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <?php
            if ( has_post_thumbnail() ) :
                the_post_thumbnail();
            endif;
            ?>
            <header class="entry-header">
                <h1 class="entry-title"><?php the_title(); ?></h1>
            </header>
            <div class="entry-content">
                <?php the_excerpt(); ?>
                <a href="<?php the_permalink(); ?>">Read More</a>
            </div>
        </article>
        <?php
    endwhile;
endif;
}
add_filter( 'wp_list_categories', 'discovertheworld_list_categories', 999, 2 );
function discovertheworld_list_categories( $output, $args ){
    $terms = get_categories( $args );
    $result = $output;
    if( $terms ):
        ob_start(); ?>
            <div class="row">
            <?php 
            foreach( $terms as $term ):
                $term_meta = get_term_meta( $term->term_id, 'feed_image', true); ?>
                <li class="cat-item cat-<?php echo $term->term_id; ?> col-xs-12 col-sm-6 d-flex mt-3 md-3 column">
			      <a class="<?php echo $term_meta; ?>" href="<?php echo get_term_link( $term ); ?>">
				    <?php echo '<h3>'. $term->name . '</h3>'; ?>
				    <?php
	                if ($term_meta !=="")
				    ?>
	                  <img class = "flex-fill" src = '<?php echo wp_get_attachment_url($term_meta);?>'>					
				  </a>
				  <?php dwc_list_categories_post($term->term_id); ?>
                </li>
                 <?php
            endforeach; ?>
            </div>
        <?php 
        $result = ob_get_clean();
    endif;
    return $result;
}