<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package discovertheworld
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- <link rel="profile" href="https://gmpg.org/xfn/11"> -->

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>

  <div id="page" class="site">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'discovertheworld' ); ?></a>
    <!--Main Navigation-->
    <header id="masthead" class="site-header">

      <!-- Navbar -->
      <nav id="site-navigation" class="fixed-top navbar navbar-expand-sm navbar-dark bg-secondary" role="navigation">
        <div class="container-fluid">
			<?php
			  discovertheworld_the_custom_logo();
			?>
		    <!-- Toggle button -->
			<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-toggle="collapse" data-bs-target="#menu-main"
					aria-controls="menu-main" aria-expanded="false" aria-label="Toggle navigation">
				<span class="navbar-toggler-icon"></span>
			</button>
				
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-main',
					'container_id'   => 'menu-main',
					'menu_class'     => 'nav navbar-nav ms-auto',
                    //'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
					//'container_class'=> 'navbar-collapse collapse',
                    //'walker'         => new Bootstrap_Menu_Walker(),
    				'depth'           => 2, // 1 = no dropdowns, 2 = with dropdowns.
    				'container'       => 'div',
    				'container_class' => 'collapse navbar-collapse',
				    'fallback_cb'     => 'WP_Bootstrap_Navwalker::fallback',
    				'walker'          => new WP_Bootstrap_Navwalker(),

				)
			);
						?>

        </div>
      </nav> <!-- Navbar -->

      <!-- Header image, title and description -->
      <?php if ( is_front_page() ): ?>
		<?php if ( get_header_image() ) : ?>
        <div class="wp-block-cover alignfull has-background-dim text-light bg-primary dwc-flex-col" style="background-image:url(<?php header_image();?>)">
          <?php
			// id="site-header" 
			if ( display_header_text()/*is_home()*/ ) :
			  $discovertheworld_description = get_bloginfo( 'description', 'display' );
		  ?>
			  <div class="wp-block-cover__inner-container dwc-middle">
			   <?php if ( $discovertheworld_description || is_customize_preview() ) :
				?>
				<h2 class="site-description dwc-text-shadow"><?php echo $discovertheworld_description;  ?></h2>
				  <?php endif; ?>
			   </div>
			   <div class="wp-block-cover__inner-container dwc-bottom">
				   <?php $dwc_coa_1 = 'If you have an interesting story that you want to share, please,';
				         $dwc_coa_2 = 'contact us';
				         if (pll_current_language()==='ru'){
							 $dwc_coa_1 = 'Если у тебя есть интересная история, которой ты хочешь поделиться, пожалуйста, ' ;
							 $dwc_coa_2 = 'напиши нам';
						 }

				   ?>
				   <p><span><?php echo $dwc_coa_1?></span>
					   <a href="https://discovertheworld.club/contact/" class="text-light text-decoration-none"><span class="bs-button-label  text-light"><?php echo $dwc_coa_2?></span></a>.</p>
               </div>	
			<?php endif;?>



        </div>

           <?php endif; ?> <!-- if ( get_header_image() )-->
          <?php endif; ?> <!-- if (is_front_page())-->


    </header>
	<div class="container"> <!-- close it in footer --> <div>

	
